package tests

import (
	"context"
	"fmt"
	"testing"
	"time"

	"code.justin.tv/web/users-service/client/usersclient_internal"
	"code.justin.tv/web/users-service/internal/testutils"
)

type TestDeleteFlow struct {
	Client usersclient_internal.InternalClient
}

func (f *TestDeleteFlow) Test(t *testing.T) {
	t.Run("TestHardDeleteFlowWithoutSoftDelete", f.TestHardDeleteFlowWithoutSoftDelete)
	t.Run("TestSoftDeleteFlow", f.TestSoftDeleteFlow)
	t.Run("TestUndeleteFlow", f.TestUndeleteFlow)
	t.Run("TestSoftDeleteFlow", f.TestSoftDeleteFlow)
	t.Run("TestHardDeleteFlow", f.TestHardDeleteFlow)
}

func (f *TestDeleteFlow) TestSoftDeleteFlow(t *testing.T) {
	_, err := f.Client.GetUserByID(context.Background(), testutils.GonerUserID, nil)
	if err != nil {
		t.Fatal("expected to find user before delete:", err)
	}

	if err := f.Client.SoftDeleteUser(context.Background(), testutils.GonerUserID, "test", nil); err != nil {
		t.Fatal(err)
	}

	// Extra call to expire because expire from soft delete doesn't happen quick enough
	err = safeExpire(context.Background(), f.Client, testutils.GonerUserID)
	if err != nil {
		t.Fatal(err)
	}

	time.Sleep(1 * time.Second)

	u, err := f.Client.GetUserByID(context.Background(), testutils.GonerUserID, nil)
	if err != nil {
		t.Fatal(err)
	}

	if u.DeletedOn == nil {
		t.Fatal("expected user to be deleted")
	}
}

func (f *TestDeleteFlow) TestUndeleteFlow(t *testing.T) {
	if err := f.Client.UndeleteUser(context.Background(), testutils.GonerUserID, "test", nil); err != nil {
		t.Fatal(err)
	}

	u, err := f.Client.GetUserByID(context.Background(), testutils.GonerUserID, nil)
	if err != nil {
		t.Fatal(err)
	}

	if u.DeletedOn != nil {
		t.Fatal("expected user to be undeleted")
	}
}

func (f *TestDeleteFlow) TestHardDeleteFlow(t *testing.T) {
	if err := f.Client.HardDeleteUser(context.Background(), testutils.GonerUserID, "test", false, nil); err != nil {
		t.Fatal(err)
	}

	u, err := f.Client.GetUserByID(context.Background(), testutils.GonerUserID, nil)
	if err != nil {
		t.Fatal(err)
	}

	if u.DeletedOn == nil {
		t.Fatal("expected user to be deleted")
	}
}

func (f *TestDeleteFlow) TestHardDeleteFlowWithoutSoftDelete(t *testing.T) {
	if err := f.Client.HardDeleteUser(context.Background(), testutils.GonerUserID, "test", false, nil); err == nil {
		t.Fatal("expected hard delete to fail")
	} else {
		fmt.Println(err)
	}
}
