package tests

import (
	"context"
	"fmt"
	"testing"

	"code.justin.tv/web/users-service/client/channels"
	. "code.justin.tv/web/users-service/internal/testutils"
	"code.justin.tv/web/users-service/models"
	"github.com/stretchr/testify/assert"
)

type TestGetChannelsFlow struct {
	Client channels.Client
}

func (f *TestGetChannelsFlow) Test(t *testing.T) {
	channel, err := f.Client.Get(context.Background(), AdminUserID, nil)
	if err != nil {
		assert.FailNow(t, "failed to get channel:", err.Error())
	}

	if channel == nil || !ChannelEqual(Channels[AdminUserID], *channel) {
		assert.FailNow(t, fmt.Sprintf("Properties not equal for testGetUserByIDSuccess: %s", AdminUserID))
	}

	channel, err = f.Client.GetByLogin(context.Background(), *Users[AdminUserID].Login, nil)
	if err != nil {
		assert.FailNow(t, "failed to get channel:", err.Error())
	}

	if channel == nil || !ChannelEqual(Channels[AdminUserID], *channel) {
		assert.FailNow(t, fmt.Sprintf("Properties not equal for testGetUserByIDSuccess: %s", AdminUserID))
	}

	// InlineIdentifierValidation success
	channels, err := f.Client.GetAllByParams(context.Background(), []string{AdminUserID, "test"}, &models.ChannelFilterParams{
		InlineIdentifierValidation: true,
	}, nil)
	if err != nil {
		assert.FailNow(t, "failed to get channel:", err.Error())
	}

	if len(channels.Results) != 1 {
		assert.FailNow(t, "expected 1 channel")
	}

	if len(channels.BadIdentifiers) != 1 {
		assert.FailNow(t, "expected 1 error")
	}

	// Failure in absense of InlineIdentifierValidation
	_, err = f.Client.GetAllByParams(context.Background(), []string{AdminUserID, "test"}, nil, nil)
	if err == nil {
		assert.FailNow(t, "expected failure")
	}

	fmt.Println("test get channels flow passed")
}
