package validators

import (
	"strings"

	"code.justin.tv/web/users-service/internal/utils"
	"code.justin.tv/web/users-service/models/apperror"
)

const (
	MaxDescriptionLength = 300
)

var (
	errDescriptionTooLong = apperror.New("Description specified is too long", true, "description_too_long")
)

func IsDescriptionValid(description *string) error {
	if description == nil {
		return nil
	}

	// Escape HTML characters potentially overcautiously as this is the precedent
	*description = utils.EscapeString(*description)

	// Remove all new lines as this is the precedent for description processing
	*description = strings.Replace(*description, "\n", "", -1)

	if len(*description) > MaxDescriptionLength {
		return errDescriptionTooLong
	}

	return nil
}
