package validators

import "code.justin.tv/web/users-service/models/apperror"

const (
	constGameMaxLen = 255
)

var ErrGameTooLong = apperror.New("Game name exceeds 255 characters.", true, "game_name_too_long")

func IsGameValid(game *string) error {
	if game == nil {
		return nil
	}

	length := len(*game)
	if length > constGameMaxLen {
		return ErrGameTooLong
	}
	return nil
}
