package validators

import (
	"code.justin.tv/web/users-service/models/apperror"
)

var (
	AvailableLocales    = [...]string{"ar", "bg", "cs", "da", "de", "el", "en", "es", "es-mx", "fi", "fr", "hu", "it", "ja", "ko", "nl", "no", "pl", "pt", "pt-br", "ru", "sk", "sv", "th", "tr", "vi", "zh-cn", "zh-tw", "zh"}
	BroadcasterLanguage = [...]string{"en", "zh", "zh-hk", "ja", "ko", "es", "fr", "de", "it", "pt", "sv", "no", "da", "nl", "fi", "pl", "el", "ru", "tr", "cs", "sk", "hu", "ar", "bg", "th", "vi", "asl", "other"}
	errLocaleInvalid    = apperror.New("The specified locale is invalid", true, "language_not_valid")
)

func isLocaleAvailable(locale *string) bool {
	for _, l := range AvailableLocales {
		if l == *locale {
			return true
		}
	}
	return false
}

func isBroadcasterLanguageAvailable(locale *string) bool {
	for _, l := range BroadcasterLanguage {
		if l == *locale {
			return true
		}
	}
	return false
}

func IsLanguageValid(lang *string) error {
	if lang == nil || *lang == "" {
		return nil
	}

	if !isLocaleAvailable(lang) {
		return errLocaleInvalid
	}

	return nil
}

func IsBroadcasterLanguageValid(lang *string) error {
	if lang == nil || *lang == "" {
		return nil
	}

	if !isBroadcasterLanguageAvailable(lang) {
		return errLocaleInvalid
	}

	return nil
}
