package validators

import "time"
import "code.justin.tv/web/users-service/models/apperror"

const LastLoginFormat = "2006-01-02 15:04:05" // "%Y-%m-%d %H:%M:%S"
var ErrInvalidLastLogin = apperror.New("Last Login doesn't follow format \"%Y-%m-%d %H:%M:%S\"", true, "invalid_last_login")

func IsLastLoginValid(lastLogin string) error {
	if _, err := time.Parse(LastLoginFormat, lastLogin); err != nil {
		return ErrInvalidLastLogin
	}

	return nil
}
