package validators

import (
	"regexp"

	"code.justin.tv/web/users-service/models/apperror"
)

var (
	phoneNumberFailRegex       = regexp.MustCompile(`/[a-zA-Z]/`)
	ErrInvalidPhoneNumberChars = apperror.New("phone number cannot contain letters", false, "phone_number_has_letters")
)

func IsPhoneNumberValid(pn *string) error {
	if pn == nil {
		return nil
	}

	if phoneNumberFailRegex.MatchString(*pn) {
		return ErrInvalidPhoneNumberChars
	}

	return nil
}
