package validators

import "code.justin.tv/web/users-service/models"

// ValidateProperties validates a user against flags set on FilterParams.
func ValidateProperties(upres models.Properties, params *models.FilterParams) bool {
	if params == nil {
		return true
	}

	if params.NotDeleted && upres.DeletedOn != nil {
		return false
	}

	if params.NoTOSViolation && upres.TermsOfServiceViolation != nil && *upres.TermsOfServiceViolation {
		return false
	}

	if params.NoDMCAViolation && upres.DmcaViolation != nil && *upres.DmcaViolation {
		return false
	}

	return true
}

// ValidateProperties validates a user against flags set on ChannelFilterParams.
func ValidateChannelProperties(cpres models.ChannelProperties, params *models.ChannelFilterParams) bool {
	if params == nil {
		return true
	}

	if params.NotDeleted && cpres.DeletedOn != nil {
		return false
	}

	if params.NoTOSViolation && cpres.TermsOfServiceViolation != nil && *cpres.TermsOfServiceViolation {
		return false
	}

	if params.NoDMCAViolation && cpres.DmcaViolation != nil && *cpres.DmcaViolation {
		return false
	}

	return true
}
