package validators

import "code.justin.tv/web/users-service/models/apperror"

const (
	constStatusMaxLen = 140
)

var ErrStatusTooLong = apperror.New("Title is too long.", true, "status_too_long")

func IsStatusValid(status *string) error {
	if status == nil {
		return nil
	}

	length := len(*status)
	if length > constStatusMaxLen {
		return ErrStatusTooLong
	}
	return nil
}
