# meepo-util

meepo-util is a command line utility that simplifies administering squad streaming.

## Installation

```
# Fetch the code, compile and install the utility
go get -u code.justin.tv/twitch-events/meepo-util/...
```

## Usage

### Table of Contents

- [Get squad](#get-a-squad)
- [Create squad](#create-a-live-squad)
  - [Live squad](#create-a-live-squad)
  - [Pending squad](#create-a-pending-squad)
- [Start pending squad](#start-a-pending-squad)
- [End squad](#end-a-squad)
- [Add member to squad](#add-a-member-to-a-squad)
- [Remove member from squad](#remove-a-member-from-a-squad)
- [Invite member to squad](#invite-a-member-to-a-squad)

<hr/>

### Get a squad 

By squad ID:
```
meepo-util get-squad --squad-id SQUAD_ID
```

By a member's channel login:
```
meepo-util get-squad --login LOGIN
```

Example:
```
meepo-util get-squad --login bern

{
  "id": "qetKO8CrQymJrO-QGPfatA",
  "owner_user_id": "40529315",
  "owner_user_login": "bern",
  "member_user_logins": [
    "bern",
    "turtleeatspigeon"
  ],
  "member_user_ids": [
    "40529315",
    "138289128"
  ],
  "status": "LIVE"
}
```

### Create a live squad

`meepo-util create-squad` creates a new squad with the given channel logins as members, and makes it
live.

```
meepo-util create-squad OWNER_LOGIN [MEMBER_1_LOGIN] [MEMBER_2_LOGIN] [MEMBER_3_LOGIN] 
```

Example:
```
meepo-util create-squad turtleeatspigeon bern

{
  "id": "qetKO8CrQymJrO-QGPfatA",
  "owner_user_id": "40529315",
  "owner_user_login": "bern",
  "member_user_logins": [
    "bern",
    "turtleeatspigeon"
  ],
  "member_user_ids": [
    "40529315",
    "138289128"
  ],
  "status": "LIVE"
}
```

### Create a pending squad

`meepo-util create-squad` creates a new squad with the given channel logins as members, leaving it
in a PENDING state.

```
meepo-util create-squad --pending OWNER_LOGIN [MEMBER_1_LOGIN] [MEMBER_2_LOGIN] [MEMBER_3_LOGIN] 
```

Example:
```
meepo-util create-squad --pending bern turtleeatspigeon
   
{
  "id": "BIAakr_VQmSWhvESyyuB6A",
  "owner_user_id": "40529315",
  "owner_user_login": "bern",
  "member_user_logins": [
    "bern",
    "turtleeatspigeon"
  ],
  "member_user_ids": [
    "40529315",
    "138289128"
  ],
  "status": "PENDING"
}
```

### Start a pending squad

```
meepo-util start-squad SQUAD_ID
```

Example:

```
meepo-util start-squad BIAakr_VQmSWhvESyyuB6A
  
{
  "id": "BIAakr_VQmSWhvESyyuB6A",
  "owner_user_id": "40529315",
  "owner_user_login": "bern",
  "member_user_logins": [
    "bern",
    "turtleeatspigeon"
  ],
  "member_user_ids": [
    "40529315",
    "138289128"
  ],
  "status": "LIVE"
}
```

### End a squad

`meepo-util end-squad` ends the squad with the given squad ID.


```
meepo-util end-squad SQUAD_ID 

```

Example:

```
meepo-util end-squad qetKO8CrQymJrO-QGPfatA

{
  "id": "qetKO8CrQymJrO-QGPfatA",
  "status": "ENDED"
}
```

### Add a member to a squad

```
meepo-util add-member SQUAD_ID LOGIN
```

Example:

```
meepo-util add-member T5Y7zBM_TXK9LbyxCVbpow jor

{
  "id": "T5Y7zBM_TXK9LbyxCVbpow",
  "owner_user_id": "40529315",
  "owner_user_login": "bern",
  "member_user_logins": [
    "bern",
    "turtleeatspigeon",
    "jor"
  ],
  "member_user_ids": [
    "40529315",
    "138289128",
    "123333107"
  ],
  "status": "LIVE"
}
```

### Remove a member from a squad

```
meepo-util remove-member LOGIN
```

Example:

```
meepo-util remove-member bern

{
  "id": "T5Y7zBM_TXK9LbyxCVbpow",
  "owner_user_id": "138289128",
  "owner_user_login": "turtleeatspigeon",
  "member_user_logins": [
    "turtleeatspigeon",
    "jor"
  ],
  "member_user_ids": [
    "138289128",
    "123333107"
  ],
  "status": "LIVE"
}
```

### Invite a member to a squad

```
meepo-util invite-member SQUAD_ID RECIPIENT_LOGIN_OR_ID
```

Example:

```
meepo-util invite-member 8XBrcOOiQoeaTEr-ef73Nw monstercat

{
  "id": "8XBrcOOiQoeaTEr-ef73Nw",
  "owner_user_id": "267332047",
  "owner_user_login": "grizzly",
  "member_user_logins": [
    "grizzly"
  ],
  "member_user_ids": [
    "267332047"
  ],
  "status": "PENDING",
  "pending_invitations": [
    {
      "id": "7d0FGy-ARSOKVjjDtzOxTQ",
      "recipient_id": "27446517",
      "recipient_login": "monstercat"
    }
  ]
}
```

## Common Problems

### My user login/squad ID/member ID starts with a "-" and the CLI thinks it's a flag rather than an argument!

You can use `--` to stop the CLI from parsing flags. For example, `meepo-util invite-member -ZbkXf9fS8OhzzXKamOWuQ bern` won't work, but `meepo-util invite-member -- -ZbkXf9fS8OhzzXKamOWuQ bern` would send the member invitation.
