package clients

import (
	"net/http"
	"time"

	pdms "code.justin.tv/amzn/PDMSLambdaTwirp"
	twirplambdatransport "code.justin.tv/amzn/TwirpGoLangAWSTransports/lambda"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials/stscreds"
	"github.com/aws/aws-sdk-go/aws/endpoints"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/lambda"
)

// PDMSClient is used to encapsulate pdms service.
type PDMSClient interface {
	pdms.PDMSService
}

// NewPDMSClient creates a new pdms client.
func NewPDMSClient(pdmsCallerRole string, pdmsLambdaARN string) PDMSClient {
	sess := session.Must(session.NewSessionWithOptions(session.Options{
		Config: aws.Config{
			Region:              aws.String("us-west-2"),
			STSRegionalEndpoint: endpoints.RegionalSTSEndpoint,
			// We want a long timeout for PDMS, as Lambda based services can take a while to warm up on cold start.
			HTTPClient: &http.Client{Timeout: 10 * time.Second},
		},
	}))
	creds := stscreds.NewCredentials(sess, pdmsCallerRole)
	pdmsLambdaCli := lambda.New(sess, &aws.Config{Credentials: creds})
	pdmsTransport := twirplambdatransport.NewClient(pdmsLambdaCli, pdmsLambdaARN)
	client := pdms.NewPDMSServiceProtobufClient("", pdmsTransport)
	return client
}
