package config

import (
	"encoding/json"
	"io/ioutil"
	"os"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func TestConfig(t *testing.T) {
	Convey("Development Config", t, func() {
		jsonFile, fileErr := os.Open("./development.json")
		So(fileErr, ShouldBeNil)

		byteValue, _ := ioutil.ReadAll(jsonFile)
		var objmap map[string]interface{}
		jsonErr := json.Unmarshal(byteValue, &objmap)
		So(jsonErr, ShouldBeNil)
	})

	Convey("Staging Config", t, func() {
		jsonFile, fileErr := os.Open("./staging.json")
		So(fileErr, ShouldBeNil)

		byteValue, _ := ioutil.ReadAll(jsonFile)
		var objmap map[string]interface{}
		jsonErr := json.Unmarshal(byteValue, &objmap)
		So(jsonErr, ShouldBeNil)
	})

	Convey("Production Config", t, func() {
		jsonFile, fileErr := os.Open("./production.json")
		So(fileErr, ShouldBeNil)

		byteValue, _ := ioutil.ReadAll(jsonFile)
		var objmap map[string]interface{}
		jsonErr := json.Unmarshal(byteValue, &objmap)
		So(jsonErr, ShouldBeNil)
	})
}
