# DB migrations

All migrations are located in [\_db/migrations](./../_db/migrations) folder. To make modifications to the postgres RDS database, create new migration files using [https://github.com/golang-migrate/migrate/cli](https://github.com/golang-migrate/migrate/tree/master/cli) (installed when running `make setup`) and apply them.

Make sure you have your `~/.pgpass` setup for meepo's staging and/or production databases.

All migrations must follow this process:

* Create two migration files, one for up and one for down
* Test the migration by running it on the staging database
* Submit a PR with the migration code
* Once reviewed, merge the PR into master
* Run the PR against the production database

To generate new migration files (up and down):

```bash
migrate create -ext sql -dir _db/migrations {name_of_migration}
```

To run migrations on databases:

```bash
migrate -source file://_db/migrations -database postgres://master@events-meepo-staging.cx90n2nqhct4.us-west-2.rds.amazonaws.com:5432/meepo up # staging
migrate -source file://_db/migrations -database postgres://master@events-meepo-production.ctznl8hapsy5.us-west-2.rds.amazonaws.com:5432/meepo up # production
```
