package api

import (
	"context"

	meepoerrors "code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/internal/models"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/twitchtv/twirp"
)

// AcceptInvitation accepts an invitation, adds the recipient as a member to the squad, and returns the invitation.
func (s *HTTPServer) AcceptInvitation(ctx context.Context, r *meepo.AcceptInvitationRequest) (*meepo.AcceptInvitationResponse, error) {
	if r.GetInvitationId() == "" {
		return nil, twirp.RequiredArgumentError("invitation_id").WithMeta(meepoerrors.ErrMetaKey, meepoerrors.ErrArgumentMissing)
	}
	invitationID := r.GetInvitationId()

	if r.GetCallerId() == "" {
		return nil, twirp.RequiredArgumentError("caller_id").WithMeta(meepoerrors.ErrMetaKey, meepoerrors.ErrArgumentMissing)
	}
	callerID := r.GetCallerId()

	invitation, err := s.Auth.AcceptInvitation(ctx, invitationID, callerID)
	if err != nil {
		return nil, err
	}

	invitationProto, err := models.NewProtoFromInvitation(invitation)
	if err != nil {
		return nil, err
	}

	return &meepo.AcceptInvitationResponse{
		Invitation: invitationProto,
	}, nil
}
