package api

import (
	"context"

	"code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/twitchtv/twirp"
)

// AuthorizeTopicSubscription determines whether the caller is authorized to subscribe to a PubSub topic.
func (s *HTTPServer) AuthorizeTopicSubscription(ctx context.Context, r *meepo.AuthorizeTopicSubscriptionRequest) (*meepo.AuthorizeTopicSubscriptionResponse, error) {
	if r.GetTopic() == "" {
		return nil, twirp.RequiredArgumentError("topic").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	topic := r.GetTopic()

	if r.GetCallerId() == "" {
		return nil, twirp.RequiredArgumentError("caller_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	callerID := r.GetCallerId()

	isAuthorized, err := s.Auth.AuthorizeTopicSubscription(ctx, topic, callerID)
	if err != nil {
		return nil, err
	}

	return &meepo.AuthorizeTopicSubscriptionResponse{
		IsAuthorized: isAuthorized,
	}, nil
}
