package api

import (
	"context"

	"code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/twitchtv/twirp"
)

// CanAccessSquads determines if a channel ID has access to squad management features.
func (s *HTTPServer) CanAccessSquads(ctx context.Context, r *meepo.CanAccessSquadsRequest) (*meepo.CanAccessSquadsResponse, error) {
	if r.GetChannelId() == "" {
		return nil, twirp.RequiredArgumentError("channel_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	channelID := r.GetChannelId()

	canAccessSquads, err := s.Backend.CanAccessSquads(ctx, channelID)
	if err != nil {
		// if we error due to downstream dependencies, do not return a 500 error
		s.Log.LogCtx(ctx, "err", err, "squads temporarily unavailable")
		return &meepo.CanAccessSquadsResponse{
			CanAccessSquads:              false,
			SquadsTemporarilyUnavailable: true,
		}, nil
	}

	return &meepo.CanAccessSquadsResponse{
		CanAccessSquads:              canAccessSquads,
		SquadsTemporarilyUnavailable: false,
	}, nil
}
