package api

import (
	"context"

	meepoerrors "code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/internal/models"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/twitchtv/twirp"
)

// CreateInvitation creates an invitation from a user's squad to another user, and returns the invitation.
func (s *HTTPServer) CreateInvitation(ctx context.Context, r *meepo.CreateInvitationRequest) (*meepo.CreateInvitationResponse, error) {
	if r.GetSenderId() == "" {
		return nil, twirp.RequiredArgumentError("sender_id").WithMeta(meepoerrors.ErrMetaKey, meepoerrors.ErrArgumentMissing)
	}
	senderID := r.GetSenderId()

	if r.GetRecipientId() == "" {
		return nil, twirp.RequiredArgumentError("recipient_id").WithMeta(meepoerrors.ErrMetaKey, meepoerrors.ErrArgumentMissing)
	}
	recipientID := r.GetRecipientId()

	if r.GetCallerId() == "" {
		return nil, twirp.RequiredArgumentError("caller_id").WithMeta(meepoerrors.ErrMetaKey, meepoerrors.ErrArgumentMissing)
	}
	callerID := r.GetCallerId()

	invitation, err := s.Auth.CreateInvitation(ctx, senderID, recipientID, callerID)
	if err != nil {
		return nil, err
	}

	invitationProto, err := models.NewProtoFromInvitation(invitation)
	if err != nil {
		return nil, err
	}

	return &meepo.CreateInvitationResponse{
		Invitation: invitationProto,
	}, nil
}
