package api

import (
	"context"

	"code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/internal/models"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/twitchtv/twirp"
)

// CreateMembership adds a user as a member to a squad, and returns the membership.
func (s *HTTPServer) CreateMembership(ctx context.Context, r *meepo.CreateMembershipRequest) (*meepo.CreateMembershipResponse, error) {
	if r.GetTargetUserId() == "" {
		return nil, twirp.RequiredArgumentError("target_user_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	targetuserID := r.GetTargetUserId()

	if r.GetSquadId() == "" {
		return nil, twirp.RequiredArgumentError("squad_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	squadID := r.GetSquadId()

	if r.GetCallerId() == "" {
		return nil, twirp.RequiredArgumentError("caller_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	callerID := r.GetCallerId()

	membership, err := s.Auth.CreateMembership(ctx, targetuserID, squadID, callerID)
	if err != nil {
		return nil, err
	}

	membershipProto, err := models.NewProtoFromMember(membership)
	if err != nil {
		return nil, err
	}

	return &meepo.CreateMembershipResponse{
		Membership: membershipProto,
	}, nil
}
