package api

import (
	"context"

	"code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/internal/models"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/twitchtv/twirp"
)

// CreateSquad creates a squad with the given user as the owner, and returns the squad.
func (s *HTTPServer) CreateSquad(ctx context.Context, r *meepo.CreateSquadRequest) (*meepo.CreateSquadResponse, error) {
	if r.GetOwnerId() == "" {
		return nil, twirp.RequiredArgumentError("owner_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	ownerID := r.GetOwnerId()

	if r.GetCallerId() == "" {
		return nil, twirp.RequiredArgumentError("caller_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	callerID := r.GetCallerId()

	squad, err := s.Auth.CreateSquad(ctx, ownerID, callerID)
	if err != nil {
		return nil, err
	}

	squadProto, err := models.NewProtoFromSquad(squad)
	if err != nil {
		return nil, err
	}

	return &meepo.CreateSquadResponse{
		Squad: squadProto,
	}, nil
}
