package api

import (
	"context"

	"code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/internal/models"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/twitchtv/twirp"
)

// DeleteInvitation deletes an invitation, changes invitation status to deleted, and returns the deleted invitation.
func (s *HTTPServer) DeleteInvitation(ctx context.Context, r *meepo.DeleteInvitationRequest) (*meepo.DeleteInvitationResponse, error) {
	if r.GetInvitationId() == "" {
		return nil, twirp.RequiredArgumentError("invitation_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	invitationID := r.GetInvitationId()

	if r.GetCallerId() == "" {
		return nil, twirp.RequiredArgumentError("caller_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	callerID := r.GetCallerId()

	invitation, err := s.Auth.DeleteInvitation(ctx, invitationID, callerID)
	if err != nil {
		return nil, err
	}

	invitationProto, err := models.NewProtoFromInvitation(invitation)
	if err != nil {
		return nil, err
	}

	return &meepo.DeleteInvitationResponse{
		Invitation: invitationProto,
	}, nil
}
