package api

import (
	"context"

	"code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/twitchtv/twirp"
)

// DeleteUser removes the channel from its current squad and deletes pending incoming invitations.
func (s *HTTPServer) DeleteUser(ctx context.Context, r *meepo.DeleteUserRequest) (*meepo.DeleteUserResponse, error) {
	if r.GetChannelId() == "" {
		return nil, twirp.RequiredArgumentError("channel_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	channelID := r.GetChannelId()

	if err := s.Backend.DeleteUser(ctx, channelID); err != nil {
		return nil, err
	}

	return &meepo.DeleteUserResponse{}, nil
}
