package api

import (
	"context"

	"code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/twitchtv/twirp"
)

// DestroyUser removes the channel from its current squad, deletes pending incoming invitations, and removes all user
// preference data related to squad stream.
func (s *HTTPServer) DestroyUser(ctx context.Context, r *meepo.DestroyUserRequest) (*meepo.DestroyUserResponse, error) {
	if r.GetChannelId() == "" {
		return nil, twirp.RequiredArgumentError("channel_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	channelID := r.GetChannelId()

	if err := s.Backend.DestroyUser(ctx, channelID); err != nil {
		return nil, err
	}

	return &meepo.DestroyUserResponse{}, nil
}
