package api

import (
	"context"

	"code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/internal/models"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/twitchtv/twirp"
)

// GetIncomingInvitationsByChannelID returns the invitations to the given channel.
func (s *HTTPServer) GetIncomingInvitationsByChannelID(ctx context.Context, r *meepo.GetIncomingInvitationsByChannelIDRequest) (*meepo.GetIncomingInvitationsByChannelIDResponse, error) {
	if r.GetChannelId() == "" {
		return nil, twirp.RequiredArgumentError("channel_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	channelID := r.GetChannelId()

	if r.GetCallerId() == "" {
		return nil, twirp.RequiredArgumentError("caller_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	callerID := r.GetCallerId()

	invitations, err := s.Auth.GetPendingInvitationsByRecipientID(ctx, channelID, callerID)
	if err != nil {
		return nil, err
	}

	invitationsProto := make([]*meepo.Invitation, len(invitations))

	for idx, invitation := range invitations {
		invitationProto, err := models.NewProtoFromInvitation(invitation)
		if err != nil {
			return nil, err
		}

		invitationsProto[idx] = invitationProto
	}

	return &meepo.GetIncomingInvitationsByChannelIDResponse{
		Invitations: invitationsProto,
	}, nil
}
