package api

import (
	"context"

	"code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/twitchtv/twirp"
)

// GetIncomingInvitationsCountByChannelID counts number of incoming, pending invitation for a channel ID.
func (s *HTTPServer) GetIncomingInvitationsCountByChannelID(ctx context.Context, r *meepo.GetIncomingInvitationsCountByChannelIDRequest) (*meepo.GetIncomingInvitationsCountByChannelIDResponse, error) {
	if r.GetChannelId() == "" {
		return nil, twirp.RequiredArgumentError("channel_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	channelID := r.GetChannelId()

	if r.GetCallerId() == "" {
		return nil, twirp.RequiredArgumentError("caller_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	callerID := r.GetCallerId()

	count, err := s.Auth.GetPendingInvitationsCountByRecipientID(ctx, channelID, callerID)
	if err != nil {
		return nil, err
	}

	return &meepo.GetIncomingInvitationsCountByChannelIDResponse{
		Count: count,
	}, nil
}
