package api

import (
	"context"

	"code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/internal/models"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/twitchtv/twirp"
)

// GetInvitePolicyByChannelID returns the squad stream invite policy of a given channel ID.
func (s *HTTPServer) GetInvitePolicyByChannelID(ctx context.Context, r *meepo.GetInvitePolicyByChannelIDRequest) (*meepo.GetInvitePolicyByChannelIDResponse, error) {
	if r.GetChannelId() == "" {
		return nil, twirp.RequiredArgumentError("channel_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	if r.GetCallerId() == "" {
		return nil, twirp.RequiredArgumentError("caller_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}

	channelID := r.GetChannelId()
	callerID := r.GetCallerId()

	invitePolicy, err := s.Backend.GetInvitePolicyByChannelID(ctx, channelID, callerID)
	if err != nil {
		return nil, err
	}

	return &meepo.GetInvitePolicyByChannelIDResponse{
		InvitePolicy: models.NewProtoFromInvitationPolicy(invitePolicy.InvitePolicy),
	}, nil
}
