package api

import (
	"context"

	"code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/internal/models"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"

	"github.com/twitchtv/twirp"
	"google.golang.org/protobuf/types/known/timestamppb"
)

// GetSquadByChannelID returns the squad the channel belongs to, if it exists.
func (s *HTTPServer) GetSquadByChannelID(ctx context.Context, r *meepo.GetSquadByChannelIDRequest) (*meepo.GetSquadByChannelIDResponse, error) {
	if r.GetChannelId() == "" {
		return nil, twirp.RequiredArgumentError("channel_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	if squad, exists := s.Config.staticSquadsMap[r.GetChannelId()]; exists {
		return &meepo.GetSquadByChannelIDResponse{
			Squad: &meepo.Squad{
				Id:        r.GetChannelId(),
				OwnerId:   r.GetChannelId(),
				MemberIds: squad,
				Status:    meepo.Squad_LIVE,
				CreatedAt: timestamppb.Now(),
				UpdatedAt: timestamppb.Now(),
			},
		}, nil
	}

	channelID := r.GetChannelId()
	squad, err := s.Backend.GetSquadByChannelID(ctx, channelID)
	if err != nil {
		return nil, err
	}

	squadProto, err := models.NewProtoFromSquad(squad)
	if err != nil {
		return nil, err
	}

	return &meepo.GetSquadByChannelIDResponse{
		Squad: squadProto,
	}, nil
}
