package api

import (
	"context"

	"code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/internal/models"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/twitchtv/twirp"
)

// GetSquadByID returns the squad information for the given squad ID, if it exists.
func (s *HTTPServer) GetSquadByID(ctx context.Context, r *meepo.GetSquadByIDRequest) (*meepo.GetSquadByIDResponse, error) {
	if r.GetId() == "" {
		return nil, twirp.RequiredArgumentError("id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}

	id := r.GetId()
	squad, err := s.Backend.GetSquadByID(ctx, id)
	if err != nil {
		return nil, err
	}

	squadProto, err := models.NewProtoFromSquad(squad)
	if err != nil {
		return nil, err
	}

	return &meepo.GetSquadByIDResponse{
		Squad: squadProto,
	}, nil
}
