package api

import (
	"context"

	"code.justin.tv/twitch-events/meepo/errors"
	meepoerrors "code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/internal/models"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/twitchtv/twirp"
)

// LeaveSquad deletes the user from a squad, and returns the new squad.
func (s *HTTPServer) LeaveSquad(ctx context.Context, r *meepo.LeaveSquadRequest) (*meepo.LeaveSquadResponse, error) {
	if r.GetMemberId() == "" {
		return nil, twirp.RequiredArgumentError("member_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	memberID := r.GetMemberId()

	if r.GetSquadId() == "" {
		return nil, twirp.RequiredArgumentError("squad_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	squadID := r.GetSquadId()

	if r.GetCallerId() == "" {
		return nil, twirp.RequiredArgumentError("caller_id").WithMeta(meepoerrors.ErrMetaKey, meepoerrors.ErrArgumentMissing)
	}
	callerID := r.GetCallerId()

	squad, err := s.Auth.LeaveSquad(ctx, memberID, squadID, callerID)
	if err != nil {
		return nil, err
	}

	squadProto, err := models.NewProtoFromSquad(squad)
	if err != nil {
		return nil, err
	}

	return &meepo.LeaveSquadResponse{
		Squad: squadProto,
	}, nil
}
