package api

import (
	"context"

	"code.justin.tv/eventbus/schema/pkg/user"
	"code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/vod/eventbus"
	"github.com/golang/protobuf/ptypes/wrappers"
	"github.com/twitchtv/twirp"
)

// ProcessUserDestroy is used to handle eventbus user deletions with PDMS.
func (s *HTTPServer) ProcessUserDestroy(ctx context.Context, event *user.UserDestroy, cursor *wrappers.StringValue) (*eventbus.ConsumeEventResponse, error) {
	if event.GetUserId() == "" {
		return nil, twirp.RequiredArgumentError("user_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	return s.Backend.ProcessUserDestroy(ctx, event, cursor)
}
