package api

import (
	"errors"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
	. "github.com/stretchr/testify/mock"
	"golang.org/x/net/context"

	"code.justin.tv/eventbus/schema/pkg/user"
	"code.justin.tv/twitch-events/meepo/internal/mocks"
	"code.justin.tv/vod/eventbus"
)

func TestProcessUserDestroy(t *testing.T) {
	Convey("when calling ProcessUserDestroy", t, func() {
		mockBackend := &mocks.Backender{}
		s := HTTPServer{Backend: mockBackend}
		ctx := context.Background()

		Convey("requests fails", func() {

			Convey("invalid request params", func() {
				Convey("no user id", func() {
					req := &user.UserDestroy{}

					resp, err := s.ProcessUserDestroy(ctx, req, nil)
					So(err, ShouldNotBeNil)
					So(resp, ShouldBeNil)
				})
			})

			Convey("fails on backend failure", func() {
				req := &user.UserDestroy{
					UserId: "mashytestid",
				}

				backendErr := errors.New("something bad happened")
				mockBackend.On("ProcessUserDestroy", ctx, req, Anything).Return(nil, backendErr).Once()

				resp, err := s.ProcessUserDestroy(ctx, req, nil)
				So(err, ShouldNotBeNil)
				So(resp, ShouldBeNil)

			})
		})

		Convey("request succeeds", func() {
			req := &user.UserDestroy{
				UserId: "mashytestid",
			}

			mockBackend.On("ProcessUserDestroy", ctx, req, Anything).Return(&eventbus.ConsumeEventResponse{}, nil).Once()

			resp, err := s.ProcessUserDestroy(ctx, req, nil)
			So(err, ShouldBeNil)
			So(resp, ShouldNotBeNil)
		})
	})
}
