package api

import (
	"context"

	"code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/internal/models"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/twitchtv/twirp"
)

// RejectInvitation updates invitation status to rejected,
// and ensures that a max number of rejected invitations is respected.
// Returns the rejected invitation.
func (s *HTTPServer) RejectInvitation(ctx context.Context, r *meepo.RejectInvitationRequest) (*meepo.RejectInvitationResponse, error) {
	reasonToReject := models.InvitationRecipientRejected

	if r.GetInvitationId() == "" {
		return nil, twirp.RequiredArgumentError("invitation_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	invitationID := r.GetInvitationId()

	if r.GetCallerId() == "" {
		return nil, twirp.RequiredArgumentError("caller_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	callerID := r.GetCallerId()

	invitation, err := s.Auth.RejectInvitation(ctx, invitationID, callerID, reasonToReject)
	if err != nil {
		return nil, err
	}

	invitationProto, err := models.NewProtoFromInvitation(invitation)
	if err != nil {
		return nil, err
	}

	return &meepo.RejectInvitationResponse{
		Invitation: invitationProto,
	}, nil
}
