package api

import (
	"context"

	"code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/internal/models"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/twitchtv/twirp"
)

// RejectOutOfNetworkInvitations updates the status of a channel's out-of-network, pending invitations to rejected,
// and ensures that a max number of rejected invitations is respected.
func (s *HTTPServer) RejectOutOfNetworkInvitations(ctx context.Context, r *meepo.RejectOutOfNetworkInvitationsRequest) (*meepo.RejectOutOfNetworkInvitationsResponse, error) {
	reasonToReject := models.InvitationRecipientRejected

	if r.GetChannelId() == "" {
		return nil, twirp.RequiredArgumentError("channel_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	channelID := r.GetChannelId()

	if r.GetCallerId() == "" {
		return nil, twirp.RequiredArgumentError("caller_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	callerID := r.GetCallerId()

	err := s.Auth.RejectOutOfNetworkInvitations(ctx, channelID, callerID, reasonToReject)
	if err != nil {
		return nil, err
	}

	return &meepo.RejectOutOfNetworkInvitationsResponse{}, nil
}
