package api

import (
	"context"

	"code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/internal/models"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/twitchtv/twirp"
)

// RemoveMember deletes a user from a squad as requested by another user, and returns the new squad.
func (s *HTTPServer) RemoveMember(ctx context.Context, r *meepo.RemoveMemberRequest) (*meepo.RemoveMemberResponse, error) {
	if r.GetMemberId() == "" {
		return nil, twirp.RequiredArgumentError("member_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	memberID := r.GetMemberId()

	if r.GetSquadId() == "" {
		return nil, twirp.RequiredArgumentError("squad_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}

	squadID := r.GetSquadId()

	if r.GetCallerId() == "" {
		return nil, twirp.RequiredArgumentError("caller_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	callerID := r.GetCallerId()

	squad, err := s.Auth.RemoveMember(ctx, memberID, squadID, callerID)
	if err != nil {
		return nil, err
	}

	squadProto, err := models.NewProtoFromSquad(squad)
	if err != nil {
		return nil, err
	}

	return &meepo.RemoveMemberResponse{
		Squad: squadProto,
	}, nil
}
