package api

import (
	"context"

	"code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/internal/models"
	"code.justin.tv/twitch-events/meepo/rpc/meepo"
	"github.com/twitchtv/twirp"
)

// UpdateInvitePolicyByChannelID sets the squad stream invite policy of a given channel ID.
func (s *HTTPServer) UpdateInvitePolicyByChannelID(ctx context.Context, r *meepo.UpdateInvitePolicyByChannelIDRequest) (*meepo.UpdateInvitePolicyByChannelIDResponse, error) {
	if r.GetChannelId() == "" {
		return nil, twirp.RequiredArgumentError("channel_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	if r.GetCallerId() == "" {
		return nil, twirp.RequiredArgumentError("caller_id").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}
	if r.GetInvitePolicy() == meepo.InvitePolicy_UNKNOWN {
		return nil, twirp.RequiredArgumentError("invite_policy").WithMeta(errors.ErrMetaKey, errors.ErrArgumentMissing)
	}

	channelID := r.GetChannelId()
	callerID := r.GetCallerId()
	invitePolicy := models.NewInvitationPolicyFromProto(r.GetInvitePolicy())

	updatedInvitePolicy, err := s.Backend.UpdateInvitePolicyByChannelID(ctx, channelID, callerID, invitePolicy)
	if err != nil {
		return nil, err
	}

	return &meepo.UpdateInvitePolicyByChannelIDResponse{
		InvitePolicy: models.NewProtoFromInvitationPolicy(updatedInvitePolicy.InvitePolicy),
	}, nil
}
