package backend

import (
	"strings"

	"code.justin.tv/twitch-events/meepo/internal/models"
)

// isOwnerWithSquad checks whether a user is an owner of the squad given the squad.
func (b *backend) isOwnerWithSquad(userID string, dbSquad *models.DBSquad) bool {
	if dbSquad == nil {
		return false
	}

	if !dbSquad.OwnerID.Valid {
		return false
	}

	return dbSquad.OwnerID.String == userID
}

// isAdmin checking whether a user is allowed to perform any operation in the meepo
// system using a list of user IDs in Consul.
// Edit: Consul use is now deprecated and no longer called by Meepo. Other distconf
// methods may work for populating a manual admin users list, so leaving this function.
func (b *backend) isAdmin(userID string) bool {
	if userID == "" {
		return false
	}

	adminsStr := b.config.adminUsers.Get()
	admins := strings.Split(adminsStr, ",")
	for _, admin := range admins {
		if admin == userID {
			return true
		}
	}
	return false
}
