package backend

import (
	"context"
	"strings"

	"code.justin.tv/twitch-events/meepo/clients"
)

func (b *backend) CanAccessSquads(ctx context.Context, channelID string) (bool, error) {
	validated, err := b.Clients.Users.ValidateUser(ctx, channelID)
	if err != nil {
		if _, ok := err.(*clients.UserValidationError); ok {
			b.log.LogCtx(ctx, "validationErr", err, "userID", channelID, "user is invalid")
			return false, nil
		}
	}

	if !validated || err != nil {
		return false, err
	}

	whitelistStr := b.config.squadEnabledWhitelist.Get()
	whitelist := strings.Split(whitelistStr, ",")
	for _, id := range whitelist {
		if id == channelID {
			return true, nil
		}
	}

	arePartnersEnabled := b.config.squadEnabledForPartners.Get()
	areAffiliatesEnabled := b.config.squadEnabledForAffiliates.Get()

	if arePartnersEnabled || areAffiliatesEnabled {
		userPayoutType, err := b.Clients.Ripley.GetUserPayoutType(ctx, channelID)
		if err != nil {
			return false, err
		}

		if arePartnersEnabled && userPayoutType.IsPartner {
			return true, nil
		}
		if areAffiliatesEnabled && userPayoutType.IsAffiliate {
			return true, nil
		}
	}

	return false, nil
}
