package backend

import (
	"context"

	"code.justin.tv/twitch-events/meepo/internal/models"
)

func (b *backend) channelCanInviteUser(ctx context.Context, channelID, recipientID string) (bool, error) {
	recipientInvitePolicy, err := b.getInvitePolicyByChannelIDAuthed(ctx, recipientID)
	if err != nil {
		return false, nil
	}

	if recipientInvitePolicy.InvitePolicy == models.InvitationPolicyAll {
		return true, nil
	} else if recipientInvitePolicy.InvitePolicy == models.InvitationPolicyNone {
		return false, nil
	}

	inNetwork, err := b.isInNetwork(ctx, recipientID, channelID)
	if err != nil {
		// we log but don't propagate the error up if some downstream services are failing for determining network status
		b.log.LogCtx(ctx, "err", err, "recipient_id", recipientID, "sender_id", channelID,
			"error checking network information while determining whether sender_id can invite recipient_id",
		)
	}

	return inNetwork, nil
}
