package backend

import (
	"context"

	"code.justin.tv/twitch-events/meepo/internal/models"
)

// Checks if the total number of the invitations and members of a squad is at the maximum.
func (b *backend) checkSquadAtCapacity(ctx context.Context, squad *models.DBSquad) (bool, error) {
	members, err := b.Datastore.GetMembersBySquadID(ctx, squad.ID)
	if err != nil {
		return false, err
	}

	invitations, err := b.Datastore.GetInvitationsBySquadID(ctx, squad.ID, []models.InvitationStatus{models.InvitationStatusPending})
	if err != nil {
		return false, err
	}

	return len(members)+len(invitations) >= MaxMembersAndPendingInvitations, nil
}
