package backend

import (
	"context"
	"strings"
)

func (b *backend) publishSquadStreamInviteDartNotification(ctx context.Context, senderID, recipientID, invitationID string) {
	recipientInAllowlist := false
	allowlistStr := b.config.inviteNotificationWhitelist.Get()
	if allowlistStr == "*" {
		recipientInAllowlist = true
	} else {
		allowlist := strings.Split(allowlistStr, ",")
		for _, id := range allowlist {
			if id == recipientID {
				recipientInAllowlist = true
				break
			}
		}
	}

	if recipientInAllowlist {
		resp, err := b.Dart.SendInviteNotification(ctx, senderID, recipientID, invitationID)
		if resp.GetNotificationTraceId() != "" {
			b.log.LogCtx(ctx, "notification_trace_id", resp.GetNotificationTraceId(), "notification_trace_id sending invite information to dart")
		}
		if err != nil {
			b.log.LogCtx(ctx, "error", err, "error sending invite information to dart")
		}
	}
}
