package backend

import (
	"context"
)

// DeleteExpiredData hard deletes all expired data in the database.
func (b *backend) DeleteExpiredData(ctx context.Context) (int64, error) {
	ttlInDays := int(b.config.ttlInDays.Get())
	deleteBefore := b.clock.Now().AddDate(0, 0, -ttlInDays)
	rowsDeleted := int64(0)

	squads, err := b.Datastore.HardDeleteExpiredSquads(ctx, deleteBefore)
	if err != nil {
		return rowsDeleted, err
	}
	rowsDeleted += int64(len(squads))

	for _, squad := range squads {
		b.deleteSquadFromCache(ctx, squad.ID)
	}

	invitationsDeleted, err := b.Datastore.HardDeleteExpiredInvitations(ctx, deleteBefore)
	if err != nil {
		return rowsDeleted, err
	}
	rowsDeleted += invitationsDeleted

	membersDeleted, err := b.Datastore.HardDeleteExpiredMembers(ctx, deleteBefore)
	if err != nil {
		return rowsDeleted, err
	}
	rowsDeleted += membersDeleted

	return rowsDeleted, nil
}
