package backend

import (
	"context"

	"code.justin.tv/feeds/errors"

	"code.justin.tv/twitch-events/meepo/internal/models"
)

// Cleanup rejected invitations, update status to deleted if there's too many rejected invitations.
func (b *backend) deleteRejectedInvitationsBySquadID(ctx context.Context, squadID string, maxRejectedInvitationsPerSquad int) ([]*models.DBInvitation, error) {
	// Get all rejected invitations for this squad
	rejectedDbInvitations, err := b.Datastore.GetInvitationsBySquadID(ctx, squadID, []models.InvitationStatus{models.InvitationStatusRejected})
	if err != nil {
		return nil, err
	}
	if rejectedDbInvitations == nil {
		return nil, nil
	}

	// Delete last updated rejected invitation, if over limit
	if len(rejectedDbInvitations) > maxRejectedInvitationsPerSquad {
		numberOfInvitationsToDelete := len(rejectedDbInvitations) - maxRejectedInvitationsPerSquad
		deletedInvitations := make([]*models.DBInvitation, 0, numberOfInvitationsToDelete)
		for _, rejectedDbInvitation := range rejectedDbInvitations[0:numberOfInvitationsToDelete] {
			deletedInv, err := b.Datastore.UpdateInvitationStatus(ctx, rejectedDbInvitation.ID, models.InvitationStatusDeleted)
			if err != nil {
				return nil, errors.Wrap(err, "could not delete invitations")
			}

			deletedInvitations = append(deletedInvitations, deletedInv)
		}
		return deletedInvitations, nil
	}

	return nil, nil
}
