package backend

import (
	"context"
)

// DestroyUser removes the channel from its current squad, deletes pending and rejected incoming invitations, and removes all user
// preference data related to squad stream.
func (b *backend) DestroyUser(ctx context.Context, channelID string) error {
	// Note: Hard deleting user preference, leaving current live squad, and deleting invitations are disjoint operations
	// and do not have to be executed in a specific order.

	// hard delete user preference
	if err := b.Datastore.HardDeleteInvitePolicyByChannelID(ctx, channelID); err != nil {
		return err
	}

	return b.DeleteUser(ctx, channelID)
}
