package backend

import (
	"context"

	"code.justin.tv/twitch-events/meepo/internal/models"
)

// GetInvitationByID returns the invitation for the given invitation ID, if it exists.
func (b *backend) GetInvitationByID(ctx context.Context, id string) (*models.DBInvitation, error) {
	txCtx, createdTx, err := b.Datastore.StartOrJoinTx(ctx, nil)
	if err != nil {
		return nil, err
	}
	defer b.Datastore.RollbackTxIfNotCommitted(txCtx, createdTx)

	dbInvitation, err := b.Datastore.GetInvitationByID(ctx, id)
	if err != nil {
		return nil, err
	}

	if dbInvitation == nil {
		return nil, nil
	}

	err = b.Datastore.CommitTx(txCtx, createdTx)
	if err != nil {
		return nil, err
	}

	return dbInvitation, nil
}
