package backend

import (
	"context"

	"code.justin.tv/twitch-events/meepo/internal/models"
)

// GetInvitationsBySquadID returns the invitations for the given squad, if it exists.
func (b *backend) GetInvitationsBySquadID(ctx context.Context, squadID string, status models.InvitationStatus, callerID string) ([]*models.Invitation, error) {
	dbInvitations, err := b.Datastore.GetInvitationsBySquadID(ctx, squadID, []models.InvitationStatus{status})
	if err != nil {
		return nil, err
	}

	invitations := make([]*models.Invitation, len(dbInvitations))
	for idx, dbInvitation := range dbInvitations {
		invitations[idx] = models.NewInvitationFromDB(dbInvitation)
	}

	return invitations, nil
}
