package backend

import (
	"context"

	meepo_errors "code.justin.tv/twitch-events/meepo/errors"
	"code.justin.tv/twitch-events/meepo/internal/models"
	"github.com/twitchtv/twirp"
)

// GetInvitePolicyByChannelID returns the invite policy for the given channel.
func (b *backend) GetInvitePolicyByChannelID(ctx context.Context, channelID, callerID string) (*models.InvitePolicy, error) {
	if (callerID != channelID) && !b.isAdmin(callerID) {
		b.FireSquadStreamErrorTrackingEvent(ctx, models.SquadStreamErrorTrackingEventInfo{
			ChannelID:       callerID,
			TargetChannelID: &channelID,
			Method:          models.ErrorMethodTypeGetInvitePolicyByChannelID,
			ErrorCode:       meepo_errors.ErrUnauthorized,
		})
		return nil, twirp.NewError(twirp.PermissionDenied, "The caller cannot see the channel's invite policy").WithMeta(meepo_errors.ErrMetaKey, meepo_errors.ErrUnauthorized)
	}

	return b.getInvitePolicyByChannelIDAuthed(ctx, channelID)
}

func (b *backend) getInvitePolicyByChannelIDAuthed(ctx context.Context, channelID string) (*models.InvitePolicy, error) {
	dbInvitePolicy, err := b.Datastore.GetInvitePolicyByChannelID(ctx, channelID)
	if err != nil {
		return nil, err
	}

	return models.NewInvitePolicyFromDB(dbInvitePolicy), nil
}
