package backend

import (
	"context"

	"code.justin.tv/twitch-events/meepo/internal/models"
)

type preloadedSquadData struct {
	squad               *models.DBSquad
	members             []*models.DBMember
	outgoingInvitations []*models.DBInvitation
}

func (b *backend) getManagedSquadByID(txCtx context.Context, squadID string, preload *preloadedSquadData) (*models.ManagedSquad, error) {
	if squadID == "" {
		return nil, nil
	}

	if preload == nil {
		preload = &preloadedSquadData{}
	}

	var err error

	squad := preload.squad
	if squad == nil {
		squad, err = b.Datastore.GetSquadByID(txCtx, squadID)
		if err != nil || squad == nil {
			return nil, err
		}
	}

	members := preload.members
	if members == nil {
		members, err = b.Datastore.GetMembersBySquadID(txCtx, squadID)
		if err != nil {
			return nil, err
		}
	}

	invitations := preload.outgoingInvitations
	if invitations == nil {
		invitations, err = b.loadOutgoingInvitations(txCtx, squadID)
		if err != nil {
			return nil, err
		}
	}

	return models.NewManagedSquadFromDB(squad, members, invitations), nil
}

func (b *backend) loadOutgoingInvitations(txCtx context.Context, squadID string) ([]*models.DBInvitation, error) {
	statuses := []models.InvitationStatus{models.InvitationStatusPending, models.InvitationStatusRejected}
	return b.Datastore.GetInvitationsBySquadID(txCtx, squadID, statuses)
}
