package backend

import (
	"context"

	service_common "code.justin.tv/feeds/service-common"

	"code.justin.tv/twitch-events/meepo/internal/models"
)

func (b *backend) getManagedSquadsByIDs(txCtx context.Context, squadIDs []string) ([]*models.ManagedSquad, error) {
	managedSquads := make([]*models.ManagedSquad, 0, len(squadIDs))

	errs := make([]error, len(squadIDs))
	for idx, squadID := range squadIDs {
		managedSquad, err := b.getManagedSquadByID(txCtx, squadID, nil)
		if err != nil {
			errs[idx] = err
			continue
		}

		managedSquads = append(managedSquads, managedSquad)
	}

	return managedSquads, service_common.ConsolidateErrors(errs)
}
