package backend

import (
	"context"

	"code.justin.tv/twitch-events/meepo/internal/models"
)

// GetPendingInvitationsByRecipientID returns the invitations for the given channel.
func (b *backend) GetPendingInvitationsByRecipientID(ctx context.Context, channelID string) ([]*models.Invitation, error) {
	dbInvitations, err := b.Datastore.GetInvitationsByRecipientID(
		ctx,
		channelID,
		[]models.InvitationStatus{models.InvitationStatusPending},
	)

	if err != nil {
		return nil, err
	}

	isInNetworks, errs := b.areInNetworkInvitations(ctx, dbInvitations)

	invitations := make([]*models.Invitation, len(dbInvitations))
	for idx, dbInvitation := range dbInvitations {
		invitation := models.NewInvitationFromDB(dbInvitation)
		isInNetwork, err := isInNetworks[idx], errs[idx]
		if err != nil {
			b.log.LogCtx(ctx, "recipient_id", dbInvitation.RecipientID, "sender_id", dbInvitation.SenderID, "err", err, "error checking network information")
		}
		if isInNetwork {
			invitation.NetworkType = models.InvitationInNetwork
		} else {
			invitation.NetworkType = models.InvitationOutOfNetwork
		}
		invitations[idx] = invitation
	}

	return invitations, nil
}
