package backend

import (
	"context"

	"code.justin.tv/twitch-events/meepo/internal/models"
)

// Get the number of pending, incoming invitations for a particular channelID.
func (b *backend) GetPendingInvitationsCountByRecipientID(ctx context.Context, channelID string, callerID string) (int64, error) {
	count, err := b.Datastore.GetInvitationsCountByRecipientID(ctx, channelID, []models.InvitationStatus{models.InvitationStatusPending})
	if err != nil {
		return 0, err
	}

	return count, nil
}
