package backend

import (
	"context"

	"code.justin.tv/twitch-events/meepo/internal/models"
)

// GetSquadByChannelID returns the squad, along with its members, the channel belongs to, if it exists.
func (b *backend) GetSquadByChannelID(ctx context.Context, channelID string) (*models.Squad, error) {
	squadID, exists := b.getCachedChannelMapping(ctx, channelID)
	if exists {
		if squadID == nil {
			return nil, nil
		}
		squad, err := b.GetSquadByID(ctx, *squadID)
		if err != nil {
			b.log.Log("err", err, "squadID", *squadID, "could not fetch squad ID from channel mapping cache")
		} else if squad != nil {
			// This is just a sanity check to make sure that the channel ID is still in the squad's member list
			for _, memberID := range squad.MemberIDs {
				if memberID == channelID {
					return squad, nil
				}
			}
		}
	}

	dbSquad, err := b.Datastore.GetSquadByChannelID(ctx, channelID)
	if err != nil {
		return nil, err
	}

	if dbSquad == nil {
		b.cacheChannelMapping(ctx, nil, []string{channelID})
		return nil, nil
	}

	members, err := b.Datastore.GetMembersBySquadID(ctx, dbSquad.ID)
	if err != nil {
		return nil, err
	}

	squad := models.NewSquadFromDB(dbSquad, members)
	b.cacheSquad(ctx, squad)
	return squad, nil
}
